#ifndef _BC5602_SetParameter_H_
#define _BC5602_SetParameter_H_

#include	"radio.h"

//**************************************Common Parameter Setting*****************************************//

#define		_DATARATE_		DR250KBPS          	//*daterate 		0:(DR500KBPS)-----500Kbps    *//
												   //*	       		1:(DR250KBPS)-----250Kbps    *//
										  		  //*	       		2:(DR125KBPS)-----125Kbps    *//
										  		  
										  		  												   
#define		_CRC_TYPE_		CRC_16BIT		 	//*CRC type 		0:(CRC_OFF)------- CRC off   	*//
												 //*	       		1:(CRC_8BIT)-------8 bit    	*//
										  		 //*	       		2:(CRC_16BIT)------16 bit    	*//
										  		 	
#define		_TX_POWER_		P00DBM		 		//*Tx Power 		0:(N03DBM)------- -3dBm   	*//
												//*	       			1:(P00DBM)-------- 0dBm    	*//
										  		//*	       			2:(P05DBM)-------  5dBm    	*//											  		 
												//*	       			3:(P07DBM)-------  7dBm    	*//
												
#define 	_Resend_		0					//* Auto retransmission count	     can set 0X15		  	*//

												 	
#define 	_ARD_			ARD_DLY500			//* Auto retransmission delay time	     can set 0X15		  	*//											
												//* Please refer to the datasheet for detailed parameters       *//

#define 	_Current_mode_	 0					//* crystal oscillator low current mode  0:disable  1:enable     *//


#define 	_trim_value_	21					//*  Trim value for the internal capacitor load for the crystal     *//

												
#define 	_HOPFreq_Num_	3					//*Hopping channel number*//			

#define 	_HOP_Freq1_		5					//*set Hopping channel 1*//

#define 	_HOP_Freq2_		42					//*set Hopping channel 2*//

#define 	_HOP_Freq3_		75					//*set Hopping channel 3*//	
					
																								
												
#define 	_PKT_ADDRB0_	0xBC				//*set address 1*//	

#define 	_PKT_ADDRB1_   	0x56				//*set address 2*//

#define 	_PKT_ADDRB2_	0x02				//*set address 3*//
					
#define 	_PKT_ADDRB3_	0x00				//*set address 4*//					

#define 	_PKT_ADDRB4_	0xFF				//*set address 5*//

//********************************BC5602 Parameter Setting for BC5161******************************************************//
#define		_ADDR_LEN_     AW_4BYTE          	//*address_width 	
												  	//*   1:(AW_3BYTE)-------3byte    	*//
												   	//*	 2:(AW_4BYTE)-------4byte    	*//
												   	//*	 3:(AW_5BYTE)-------5byte    	*//
												   
#define		_PCF_EN_		1					//*enable/disable PCF funtion*//
													//*if BC5161 enable PCF funtion ,must to set 1*//
													//*if BC5161 disable PCF funtion ,must to set 0*//
													
#define		_DEVICE_ID_		1					//*enable/disable BC5161 device ID funtion*//
													//*if BC5161 enable device ID funtion ,must to set 1*//
													//*if BC5161 disable device ID funtion ,must to set 0*//

													
#define		_PAIRB0_		255					//*pairing address 1*//

#define		_PAIRB1_		220					//*pairing address 2*//

#define		_PAIRB2_		0					//*pairing address 3*//		

#define		_PAIRB3_		176					//*pairing address 4*//

#define		_PAIRB4_		0					//*pairing address 5*//												

												   																						  		  
//****************************************BC5602 Parameter Setting for BC5602**********************************//
#define  _BC5602_ADDR_WIDTH_     AW_5BYTE          //*address_width*// 	
												  //*  1:(AW_3BYTE)-------3byte    	*//
												   //* 2:(AW_4BYTE)-------4byte    	*//
												   //* 3:(AW_5BYTE)-------5byte    	*//
												   
#define _RADIO_DATA_WIDTH_		    5				//*data Payload length*//


												   
#define _BC5602_Dynamic_Payload_    0x04		 	//* Dynamic Payload Set *//	
													//*  bit 0:Enable PTX Write TX FIFO with No-ACK command	*//
												 	//* bit 1: Enable PRX acknowledge with payload function 	*//
										  		 	//* bit 2: Enable dynamic payload length  *//
										  		 
#define	_BC5602_EN_Dynamic_PIPE_	0x01			//* enable pipe Dynamic Payload	mode in each pipe*//	
													//*  0:Work in fixed payload length mode *//
												  	//*    1:Work in dynamic payload length mode when EN_DPL be set to 1 *//										  		  //*	       		3:(AW_5BYTE)-------5byte    	*//

#endif
//****************************************user dont need to set**********************************//
#if (_ADDR_LEN_== AW_3BYTE)					
#define  _BC5161_RADIO_ADDR_WIDTH_     3
#endif
#if (_ADDR_LEN_== AW_4BYTE)
#define _BC5161_RADIO_ADDR_WIDTH_      4
#endif
#if (_ADDR_LEN_== AW_5BYTE)
#define _BC5161_RADIO_ADDR_WIDTH_      5
#endif

#if (_DEVICE_ID_)
#define _BC5161_Device_ID_Width		   3
#else
#define _BC5161_Device_ID_Width		   0
#endif

#define _Pairing_ADDR_Len_	 		5				//*set pairing address length*//

#define _address_len_			 	5				//*number of address*//


#if (_PCF_EN_)

#define _BC5161_Dynamic_Payload_    0x04			//* Dynamic Payload Set*//
													//*  bit 0:Enable PTX Write TX FIFO with No-ACK command	*//
												   //*   bit 1: Enable PRX acknowledge with payload function 	*//
										  		  //*	 bit 2: Enable dynamic payload length  *//
										  		 
#define	_BC5161_EN_Dynamic_PIPE_    0x01			//* enable pipe Dynamic Payload	mode in each pipe	
													//  0:Work in fixed payload length mode *//
												    //  1:Work in dynamic payload length mode when EN_DPL be set to 1 *//	
#else
	
#define _BC5161_Dynamic_Payload_    0x00			//* Dynamic Payload Set*//
													//*  bit 0:Enable PTX Write TX FIFO with No-ACK command	*//
												   //*   bit 1: Enable PRX acknowledge with payload function 	*//
										  		  //*	 bit 2: Enable dynamic payload length  *//
										  		 
#define	_BC5161_EN_Dynamic_PIPE_    0x00			//* enable pipe Dynamic Payload	mode in each pipe	
													//  0:Work in fixed payload length mode *//
												    //  1:Work in dynamic payload length mode when EN_DPL be set to 1 *//
#endif
